/*
 *   Copyright (c) 2000 Michael J. Roberts
 *   
 *   This file is part of TADS 3.  
 */

#ifndef _VECTOR_H_
#define _VECTOR_H_

/* Vector is a subclass of Array, so make sure Array is defined */
#include "array.h"


/*
 *   'Vector' metaclass 
 */
intrinsic class Vector 'vector/030001'
{
    /* 
     *   Set the length - if this is shorter than the current length,
     *   existing items will be discarded; if it's longer, the newly added
     *   slots will be set to nil.  Returns 'self'.
     */
    setLength(newElementCount);

    /* 
     *   Insert one or more elements at the given index.  If the index is
     *   1, the elements will be inserted before the first existing
     *   element.  If the index is one higher than the number of elements,
     *   the elements will be inserted after all existing elements.
     *   
     *   Note that a list value argument will simply be inserted as a
     *   single element.
     *   
     *   Returns 'self'.  
     */
    insertAt(startingIndex, val, ...);

    /*
     *   Delete the element at the given index, reducing the length of the
     *   vector by one element.  Returns 'self'.  
     */
    removeElementAt(index);

    /*
     *   Delete the range of elements starting at startingIndex and ending
     *   at endingIndex.  The elements at the ends of the range are
     *   included in the deletion.  If startingIndex == endingIndex, only
     *   one element is removed.  Reduces the length of the vector by the
     *   number of elements removed.  Returns 'self'.  
     */
    removeRange(startingIndex, endingIndex);

    /* 
     *   Append an element to the vector.  This works just like insertAt()
     *   with a starting index one higher than the length of the vector.
     *   This has almost the same effect as the '+' operator, but treats a
     *   list value like any other value by simply inserting the list as a
     *   single new element (rather than appending each item in the list
     *   individually, as the '+' operator would).  
     */
    append(val);
}

#endif /* _VECTOR_H_ */

