/* 
 *   Copyright (c) 1999, 2000 by Michael J. Roberts
 *   
 *   This file is part of TADS 3 
 */

/*
 *   TADS basic data manipulation intrinsic function set 
 */

#ifndef TADSGEN_H
#define TADSGEN_H

/*
 *   define the TADS function set 
 */
intrinsic 'tads-gen/030002'
{
    dataType(val);
    getArg(idx);
    firstObj(cls?);
    nextObj(obj, cls?);
    randomize();
    rand(x, ...);
    toString(val, radix?);
    toInteger(str, radix?);
    getTime(timeType?);
    rexMatch(pat, str);
    rexSearch(pat, str);
    rexGroup(groupNum);
    rexReplace(pat, str, replacement, flags);
    savepoint();
    undo();
    saveGame(filename);
    restoreGame(filename, retval);
    restartGame(func, arg);
    max(val1, ...);
    min(val1, ...);
    makeString(val, repeatCount?);
}

/*
 *   rexReplace() flags 
 */
#define REPLACE_ONCE  0x0000
#define REPLACE_ALL   0x0001

/*
 *   getTime() flags 
 */
#define GETTIME_DATE_AND_TIME  1
#define GETTIME_TICKS          2


#endif /* TADSGEN_H */

