/* 
 *   Copyright (c) 1999, 2000 by Michael J. Roberts
 *   
 *   This file is part of TADS 3 
 */

/*
 *   T3 intrinsic function set definition
 */

#ifndef T3_H
#define T3_H

/* 
 *   define the T3 system interface 
 */
intrinsic 't3vm/010001'
{
    /* run garbage collection */
    t3RunGC();

    /* set the default output function */
    t3SetSay(funcptr);

    /* get the VM version number */
    t3GetVMVsn();

    /* get the VM identifier string */
    t3GetVMID();

    /* get the VM banner string */
    t3GetVMBanner();

    /* get the preinitialization mode flag */
    t3GetVMPreinitMode();

    /* debugger trace operations */
    t3DebugTrace(mode, ...);
}

/*
 *   t3DebugTrace mode flags 
 */

/* check to see if the debugger is present */
#define T3DBG_CHECK     1

/* break into the debugger */
#define T3DBG_BREAK     2


#endif /* T3_H */

