/*
 *   This is a starter TADS 3 source file.  This is a complete TADS 3
 *   program that you can compile and run.
 *   
 *   To compile this game in TADS Workbench, open the "Build" menu and
 *   select "Compile for Debugging."  To run the game, after compiling it,
 *   open the "Debug" menu and select "Go."
 *   
 *   This is the "introductory" starter program; it provides an example of
 *   how to set up a T3 program.
 *   
 *   Copyright (c) 2000 by Michael J. Roberts.  Permission is granted to
 *   anyone to copy and use this file for any purpose.  
 */

/* include the TADS and T3 system headers */
#include <tads.h>
#include <t3.h>

/*
 *   Main program body.  Note that _main() is the true entrypoint into the
 *   program, but _main() calls this routine as soon as it has completed
 *   some set-up operations.  preinit() will always be called (either
 *   during the original compilation, or at program startup, depending on
 *   the compilation mode) before this routine is called.  
 */
main(args)
{
    /* show the VM banner and a blank line */
    tadsSay(t3GetVMBanner()); "\b";

    /* enter HTML mode */
    "\H+";

    /* show an introductory message */
    "Hello from TADS 3!  Type any command you like; SCORE will increase
    the score, QUIT will end the program, and everything else will
    be ignored. ";

    /* read commands */
command_loop:
    for (;;)
    {
        local cmd;

        /* increase the turn counter */
        ++global.turncount;

        /* update the status line */
        "<banner id=StatusLine height=previous border>
        <body bgcolor=statusbg text=statustext><b>
        Command Line Room
        </b>
        <tab align=right><i><<global.score>>/<<global.turncount>></i>
        </banner>";

        /* show a prompt and enter input font mode */
        "\b&gt;<font face='TADS-Input'>";

        /* read a command */
        cmd = inputLine();
        
        /* end the input font mode */
        "</font>";
        
        /* remove any leading spaces */
        cmd = rexReplace('^ +', cmd, '', REPLACE_ONCE);

        /* remove any trailing spaces */
        cmd = rexReplace(' +$', cmd, '', REPLACE_ONCE);

        /* see what we have */
        switch(cmd.toLower())
        {
        case 'quit':
            break command_loop;

        case 'score':
            "Your score has increased by ten points. ";
            global.score += 10;
            break;

        default:
            "That doesn't seem to work&emdash;yet!!! ";
            break;
        }
    }

    "Thanks for playing!!!\n";
}

/*
 *   'global' - an object where we can store some global state information 
 */
global: object
    score = 0
    turncount = 0
;

