#ifdef RCSID
static char RCSid[] =
"$Header: d:/cvsroot/tads/TADS2/msdos/ossdos32.c,v 1.2 1999/05/17 02:52:19 MJRoberts Exp $";
#endif

/* Copyright (c) 1997, 2002 Michael J. Roberts.  All Rights Reserved. */
/*
Name
  ossdos32.c - ossdos functions for win32
Function
  
Notes
  
Modified
  11/22/97 MJRoberts  - Creation
*/

#include <windows.h>
#include <wincon.h>
#include <string.h>

/*
 *   Console output buffer handle 
 */
HANDLE g_out_bufhdl;

/* original console mode */
static DWORD s_orig_console_mode;

/* screen width */
static int s_scrwid;

/* initialize console */
void oss_con_init(void)
{
    extern int os_f_plain;
    DWORD new_console_mode;
    OSVERSIONINFO ver_info;
    
    /* get the console handle */
    g_out_bufhdl = GetStdHandle(STD_OUTPUT_HANDLE);

    /* get the original console mode so we can restore it when we're done */
    GetConsoleMode(g_out_bufhdl, &s_orig_console_mode);

    /* if we're in 'plain' mode, don't change the console mode */
    if (os_f_plain)
        return;

    /* start with the original console mode bits */
    new_console_mode = s_orig_console_mode;

    /*
     *   Turn off wrapping when writing at the end of the line - the
     *   automatic wrapping screws up our scrolling, and we don't need it
     *   anyway since we keep track of all of our cursor positioning
     *   ourselves, hence it's easier if we just turn this feature off 
     */
    new_console_mode &= ~ENABLE_WRAP_AT_EOL_OUTPUT;

    /* 
     *   If we're on a 95 derivative (95, 98, ME), also clear the "processed
     *   output" flag.  This flag is necessary on NT for proper character
     *   set handling, but is not on 95/98/ME; and if that flag isn't
     *   cleared on 95/98/ME, clearing the wrap-at-eol flag has no effect.
     *   So, we must clear this flag on 95/98/ME, but we must leave it
     *   enabled on NT.  (What a pain.)
     */
    ver_info.dwOSVersionInfoSize = sizeof(ver_info);
    GetVersionEx(&ver_info);
    if (ver_info.dwPlatformId != VER_PLATFORM_WIN32_NT)
        new_console_mode &= ~ENABLE_PROCESSED_OUTPUT;

    /* set the new console mode */
    SetConsoleMode(g_out_bufhdl, new_console_mode);
}

/* uninitialize the console */
void oss_con_uninit(void)
{
    /* restore the console to normal line wrapping mode */
    SetConsoleMode(g_out_bufhdl, s_orig_console_mode);
}

/* scroll up */
void ossscu(int top, int left, int bottom, int right, int blankcolor)
{
    COORD newpos;
    SMALL_RECT pos;
    SMALL_RECT clip;
    CHAR_INFO fill;

    pos.Top = clip.Top = top;
    pos.Left = clip.Left = left;
    pos.Bottom = clip.Bottom = bottom;
    pos.Right = clip.Right = right;

    newpos.X = left;
    newpos.Y = top + 1;

    fill.Char.AsciiChar = ' ';
    fill.Attributes = blankcolor;

    ScrollConsoleScreenBuffer(g_out_bufhdl, &pos, &clip, newpos, &fill);
}

/* scroll down */
void ossscr(int top, int left, int bottom, int right, int blankcolor)
{
    COORD newpos;
    SMALL_RECT pos;
    SMALL_RECT clip;
    CHAR_INFO fill;

    pos.Top = clip.Top = top;
    pos.Left = clip.Left = left;
    pos.Bottom = clip.Bottom = bottom;
    pos.Right = clip.Right = right;

    newpos.X = left;
    newpos.Y = top - 1;

    fill.Char.AsciiChar = ' ';
    fill.Attributes = blankcolor;

    ScrollConsoleScreenBuffer(g_out_bufhdl, &pos, &clip, newpos, &fill);
}

/* clear an area of the screen */
void ossclr(int top, int left, int bottom, int right, int color)
{
    int curline;
    DWORD line_len;

    /* calculate the length of each line that we'll write */
    line_len = right - left + 1;

    /* write each line */
    for (curline = top ; curline <= bottom ; ++curline)
    {
        COORD pos;
        DWORD actual;

        pos.X = left;
        pos.Y = curline;
        FillConsoleOutputAttribute(g_out_bufhdl, (WORD)color, line_len,
                                   pos, &actual);
        FillConsoleOutputCharacter(g_out_bufhdl, ' ', line_len,
                                   pos, &actual);
    }
}

/* locate the cursor */
void ossloc(int line, int column)
{
    COORD pos;

    pos.X = column;
    pos.Y = line;
    SetConsoleCursorPosition(g_out_bufhdl, pos);
}

/* check for monochrome mode */
int ossmon(void)
{
    return 0;
}

/* display text */
void ossdsp(int line, int column, int color, const char *msg)
{
    COORD pos;
    DWORD nwritten;

    pos.X = column;
    pos.Y = line;
    SetConsoleTextAttribute(g_out_bufhdl, (WORD)color);
    SetConsoleCursorPosition(g_out_bufhdl, pos);
    WriteConsole(g_out_bufhdl, msg, strlen(msg), &nwritten, 0);
}

/* get the display metrics */
void ossgmx(int *max_linep, int *max_columnp)
{
    CONSOLE_SCREEN_BUFFER_INFO info;

    /* get the console handle */
    g_out_bufhdl = GetStdHandle(STD_OUTPUT_HANDLE);

    /* get the size of the screen and return it to the caller's variables */
    GetConsoleScreenBufferInfo(g_out_bufhdl, &info);
    *max_columnp = info.dwMaximumWindowSize.X - 1;
    *max_linep = info.dwMaximumWindowSize.Y - 1;

    /* note the screen width for our own use */
    s_scrwid = info.dwMaximumWindowSize.X;
}
